package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListServiceNetworkVpcAssociationsResponse(
    items: Iterable[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse = {
    import ListServiceNetworkVpcAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.ReadOnly =
    zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse
      .wrap(buildAwsValue())
}
object ListServiceNetworkVpcAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse =
      zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse
  ) extends zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.ReadOnly {
    override val items: List[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.ReadOnly
    ] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse
  ): zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
