package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  VpcId,
  ServiceNetworkIdentifier,
  NextToken,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListServiceNetworkVpcAssociationsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    serviceNetworkIdentifier: Optional[ServiceNetworkIdentifier] =
      Optional.Absent,
    vpcIdentifier: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest = {
    import ListServiceNetworkVpcAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        serviceNetworkIdentifier.map(value =>
          ServiceNetworkIdentifier.unwrap(value): java.lang.String
        )
      )(_.serviceNetworkIdentifier)
      .optionallyWith(
        vpcIdentifier.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsRequest.ReadOnly =
    zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsRequest
      .wrap(buildAwsValue())
}
object ListServiceNetworkVpcAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsRequest =
      zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        serviceNetworkIdentifier.map(value => value),
        vpcIdentifier.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def serviceNetworkIdentifier: Optional[ServiceNetworkIdentifier]
    def vpcIdentifier: Optional[VpcId]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceNetworkIdentifier
        : ZIO[Any, AwsError, ServiceNetworkIdentifier] = AwsError
      .unwrapOptionField("serviceNetworkIdentifier", serviceNetworkIdentifier)
    def getVpcIdentifier: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcIdentifier", vpcIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest
  ) extends zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.vpclattice.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
    override val serviceNetworkIdentifier: Optional[ServiceNetworkIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNetworkIdentifier())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceNetworkIdentifier(value)
        )
    override val vpcIdentifier: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcIdentifier())
      .map(value => zio.aws.vpclattice.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest
  ): zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
