package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ServiceNetworkIdentifier,
  ServiceIdentifier,
  NextToken,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListServiceNetworkServiceAssociationsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    serviceIdentifier: Optional[ServiceIdentifier] = Optional.Absent,
    serviceNetworkIdentifier: Optional[ServiceNetworkIdentifier] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest = {
    import ListServiceNetworkServiceAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        serviceIdentifier.map(value =>
          ServiceIdentifier.unwrap(value): java.lang.String
        )
      )(_.serviceIdentifier)
      .optionallyWith(
        serviceNetworkIdentifier.map(value =>
          ServiceNetworkIdentifier.unwrap(value): java.lang.String
        )
      )(_.serviceNetworkIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsRequest.ReadOnly =
    zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsRequest
      .wrap(buildAwsValue())
}
object ListServiceNetworkServiceAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsRequest =
      zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        serviceIdentifier.map(value => value),
        serviceNetworkIdentifier.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def serviceIdentifier: Optional[ServiceIdentifier]
    def serviceNetworkIdentifier: Optional[ServiceNetworkIdentifier]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceIdentifier: ZIO[Any, AwsError, ServiceIdentifier] =
      AwsError.unwrapOptionField("serviceIdentifier", serviceIdentifier)
    def getServiceNetworkIdentifier
        : ZIO[Any, AwsError, ServiceNetworkIdentifier] = AwsError
      .unwrapOptionField("serviceNetworkIdentifier", serviceNetworkIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest
  ) extends zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.vpclattice.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
    override val serviceIdentifier: Optional[ServiceIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceIdentifier())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceIdentifier(value)
        )
    override val serviceNetworkIdentifier: Optional[ServiceNetworkIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNetworkIdentifier())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceNetworkIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest
  ): zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
