package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRulesResponse(
    items: Iterable[zio.aws.vpclattice.model.RuleSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListRulesResponse = {
    import ListRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListRulesResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.ListRulesResponse.ReadOnly =
    zio.aws.vpclattice.model.ListRulesResponse.wrap(buildAwsValue())
}
object ListRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ListRulesResponse =
      zio.aws.vpclattice.model.ListRulesResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.vpclattice.model.RuleSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.vpclattice.model.RuleSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListRulesResponse
  ) extends zio.aws.vpclattice.model.ListRulesResponse.ReadOnly {
    override val items: List[zio.aws.vpclattice.model.RuleSummary.ReadOnly] =
      impl
        .items()
        .asScala
        .map { item =>
          zio.aws.vpclattice.model.RuleSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListRulesResponse
  ): zio.aws.vpclattice.model.ListRulesResponse.ReadOnly = new Wrapper(impl)
}
