package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListListenersResponse(
    items: Iterable[zio.aws.vpclattice.model.ListenerSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListListenersResponse = {
    import ListListenersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListListenersResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.ListListenersResponse.ReadOnly =
    zio.aws.vpclattice.model.ListListenersResponse.wrap(buildAwsValue())
}
object ListListenersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListListenersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ListListenersResponse =
      zio.aws.vpclattice.model.ListListenersResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.vpclattice.model.ListenerSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.vpclattice.model.ListenerSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListListenersResponse
  ) extends zio.aws.vpclattice.model.ListListenersResponse.ReadOnly {
    override val items
        : List[zio.aws.vpclattice.model.ListenerSummary.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.vpclattice.model.ListenerSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListListenersResponse
  ): zio.aws.vpclattice.model.ListListenersResponse.ReadOnly = new Wrapper(impl)
}
