package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ServiceIdentifier,
  NextToken,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListListenersRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    serviceIdentifier: ServiceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListListenersRequest = {
    import ListListenersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListListenersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.ListListenersRequest.ReadOnly =
    zio.aws.vpclattice.model.ListListenersRequest.wrap(buildAwsValue())
}
object ListListenersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListListenersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ListListenersRequest =
      zio.aws.vpclattice.model.ListListenersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        serviceIdentifier
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def serviceIdentifier: ServiceIdentifier
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListListenersRequest
  ) extends zio.aws.vpclattice.model.ListListenersRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.vpclattice.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListListenersRequest
  ): zio.aws.vpclattice.model.ListListenersRequest.ReadOnly = new Wrapper(impl)
}
