package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ResourceIdentifier,
  NextToken,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAccessLogSubscriptionsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    resourceIdentifier: ResourceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest = {
    import ListAccessLogSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.ListAccessLogSubscriptionsRequest.ReadOnly =
    zio.aws.vpclattice.model.ListAccessLogSubscriptionsRequest
      .wrap(buildAwsValue())
}
object ListAccessLogSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ListAccessLogSubscriptionsRequest =
      zio.aws.vpclattice.model.ListAccessLogSubscriptionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceIdentifier
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def resourceIdentifier: ResourceIdentifier
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest
  ) extends zio.aws.vpclattice.model.ListAccessLogSubscriptionsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.vpclattice.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.vpclattice.model.primitives.NextToken(value))
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest
  ): zio.aws.vpclattice.model.ListAccessLogSubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
