package zio.aws.vpclattice.model
import scala.jdk.CollectionConverters.*
sealed trait LambdaEventStructureVersion {
  def unwrap: software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion
}
object LambdaEventStructureVersion {
  def wrap(
      value: software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion
  ): zio.aws.vpclattice.model.LambdaEventStructureVersion = value match {
    case software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion.V1 =>
      val r = V1
      r
    case software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion.V2 =>
      val r = V2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.vpclattice.model.LambdaEventStructureVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion =
      software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object V1 extends zio.aws.vpclattice.model.LambdaEventStructureVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion =
      software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion.V1
  }
  case object V2 extends zio.aws.vpclattice.model.LambdaEventStructureVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion =
      software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion.V2
  }
}
