package zio.aws.vpclattice.model
import scala.jdk.CollectionConverters.*
sealed trait IpAddressType {
  def unwrap: software.amazon.awssdk.services.vpclattice.model.IpAddressType
}
object IpAddressType {
  def wrap(
      value: software.amazon.awssdk.services.vpclattice.model.IpAddressType
  ): zio.aws.vpclattice.model.IpAddressType = value match {
    case software.amazon.awssdk.services.vpclattice.model.IpAddressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.vpclattice.model.IpAddressType.IPV4 =>
      val r = IPV4
      r
    case software.amazon.awssdk.services.vpclattice.model.IpAddressType.IPV6 =>
      val r = IPV6
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.vpclattice.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.IpAddressType =
      software.amazon.awssdk.services.vpclattice.model.IpAddressType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPV4 extends zio.aws.vpclattice.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.IpAddressType =
      software.amazon.awssdk.services.vpclattice.model.IpAddressType.IPV4
  }
  case object IPV6 extends zio.aws.vpclattice.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.IpAddressType =
      software.amazon.awssdk.services.vpclattice.model.IpAddressType.IPV6
  }
}
