package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.HttpMethod
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HttpMatch(
    headerMatches: Optional[Iterable[zio.aws.vpclattice.model.HeaderMatch]] =
      Optional.Absent,
    method: Optional[HttpMethod] = Optional.Absent,
    pathMatch: Optional[zio.aws.vpclattice.model.PathMatch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.HttpMatch = {
    import HttpMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.HttpMatch
      .builder()
      .optionallyWith(
        headerMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.headerMatches)
      .optionallyWith(
        method.map(value => HttpMethod.unwrap(value): java.lang.String)
      )(_.method)
      .optionallyWith(pathMatch.map(value => value.buildAwsValue()))(
        _.pathMatch
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.HttpMatch.ReadOnly =
    zio.aws.vpclattice.model.HttpMatch.wrap(buildAwsValue())
}
object HttpMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.HttpMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.HttpMatch =
      zio.aws.vpclattice.model.HttpMatch(
        headerMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        method.map(value => value),
        pathMatch.map(value => value.asEditable)
      )
    def headerMatches
        : Optional[List[zio.aws.vpclattice.model.HeaderMatch.ReadOnly]]
    def method: Optional[HttpMethod]
    def pathMatch: Optional[zio.aws.vpclattice.model.PathMatch.ReadOnly]
    def getHeaderMatches: ZIO[Any, AwsError, List[
      zio.aws.vpclattice.model.HeaderMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("headerMatches", headerMatches)
    def getMethod: ZIO[Any, AwsError, HttpMethod] =
      AwsError.unwrapOptionField("method", method)
    def getPathMatch
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.PathMatch.ReadOnly] =
      AwsError.unwrapOptionField("pathMatch", pathMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.HttpMatch
  ) extends zio.aws.vpclattice.model.HttpMatch.ReadOnly {
    override val headerMatches
        : Optional[List[zio.aws.vpclattice.model.HeaderMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headerMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.HeaderMatch.wrap(item)
          }.toList
        )
    override val method: Optional[HttpMethod] = zio.aws.core.internal
      .optionalFromNullable(impl.method())
      .map(value => zio.aws.vpclattice.model.primitives.HttpMethod(value))
    override val pathMatch
        : Optional[zio.aws.vpclattice.model.PathMatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathMatch())
        .map(value => zio.aws.vpclattice.model.PathMatch.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.HttpMatch
  ): zio.aws.vpclattice.model.HttpMatch.ReadOnly = new Wrapper(impl)
}
