package zio.aws.vpclattice.model
import scala.jdk.CollectionConverters.*
sealed trait HealthCheckProtocolVersion {
  def unwrap: software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion
}
object HealthCheckProtocolVersion {
  def wrap(
      value: software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion
  ): zio.aws.vpclattice.model.HealthCheckProtocolVersion = value match {
    case software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion.HTTP1 =>
      val r = HTTP1
      r
    case software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion.HTTP2 =>
      val r = HTTP2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.vpclattice.model.HealthCheckProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion =
      software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP1
      extends zio.aws.vpclattice.model.HealthCheckProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion =
      software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion.HTTP1
  }
  case object HTTP2
      extends zio.aws.vpclattice.model.HealthCheckProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion =
      software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion.HTTP2
  }
}
