package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  HealthCheckPath,
  HealthCheckTimeoutSeconds,
  HealthCheckIntervalSeconds,
  HealthyThresholdCount,
  UnhealthyThresholdCount,
  HealthCheckPort
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HealthCheckConfig(
    enabled: Optional[Boolean] = Optional.Absent,
    healthCheckIntervalSeconds: Optional[HealthCheckIntervalSeconds] =
      Optional.Absent,
    healthCheckTimeoutSeconds: Optional[HealthCheckTimeoutSeconds] =
      Optional.Absent,
    healthyThresholdCount: Optional[HealthyThresholdCount] = Optional.Absent,
    matcher: Optional[zio.aws.vpclattice.model.Matcher] = Optional.Absent,
    path: Optional[HealthCheckPath] = Optional.Absent,
    port: Optional[HealthCheckPort] = Optional.Absent,
    protocol: Optional[zio.aws.vpclattice.model.TargetGroupProtocol] =
      Optional.Absent,
    protocolVersion: Optional[
      zio.aws.vpclattice.model.HealthCheckProtocolVersion
    ] = Optional.Absent,
    unhealthyThresholdCount: Optional[UnhealthyThresholdCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.HealthCheckConfig = {
    import HealthCheckConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.HealthCheckConfig
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        healthCheckIntervalSeconds.map(value =>
          HealthCheckIntervalSeconds.unwrap(value): Integer
        )
      )(_.healthCheckIntervalSeconds)
      .optionallyWith(
        healthCheckTimeoutSeconds.map(value =>
          HealthCheckTimeoutSeconds.unwrap(value): Integer
        )
      )(_.healthCheckTimeoutSeconds)
      .optionallyWith(
        healthyThresholdCount.map(value =>
          HealthyThresholdCount.unwrap(value): Integer
        )
      )(_.healthyThresholdCount)
      .optionallyWith(matcher.map(value => value.buildAwsValue()))(_.matcher)
      .optionallyWith(
        path.map(value => HealthCheckPath.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        port.map(value => HealthCheckPort.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(protocolVersion.map(value => value.unwrap))(
        _.protocolVersion
      )
      .optionallyWith(
        unhealthyThresholdCount.map(value =>
          UnhealthyThresholdCount.unwrap(value): Integer
        )
      )(_.unhealthyThresholdCount)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly =
    zio.aws.vpclattice.model.HealthCheckConfig.wrap(buildAwsValue())
}
object HealthCheckConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.HealthCheckConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.HealthCheckConfig =
      zio.aws.vpclattice.model.HealthCheckConfig(
        enabled.map(value => value),
        healthCheckIntervalSeconds.map(value => value),
        healthCheckTimeoutSeconds.map(value => value),
        healthyThresholdCount.map(value => value),
        matcher.map(value => value.asEditable),
        path.map(value => value),
        port.map(value => value),
        protocol.map(value => value),
        protocolVersion.map(value => value),
        unhealthyThresholdCount.map(value => value)
      )
    def enabled: Optional[Boolean]
    def healthCheckIntervalSeconds: Optional[HealthCheckIntervalSeconds]
    def healthCheckTimeoutSeconds: Optional[HealthCheckTimeoutSeconds]
    def healthyThresholdCount: Optional[HealthyThresholdCount]
    def matcher: Optional[zio.aws.vpclattice.model.Matcher.ReadOnly]
    def path: Optional[HealthCheckPath]
    def port: Optional[HealthCheckPort]
    def protocol: Optional[zio.aws.vpclattice.model.TargetGroupProtocol]
    def protocolVersion
        : Optional[zio.aws.vpclattice.model.HealthCheckProtocolVersion]
    def unhealthyThresholdCount: Optional[UnhealthyThresholdCount]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getHealthCheckIntervalSeconds
        : ZIO[Any, AwsError, HealthCheckIntervalSeconds] =
      AwsError.unwrapOptionField(
        "healthCheckIntervalSeconds",
        healthCheckIntervalSeconds
      )
    def getHealthCheckTimeoutSeconds
        : ZIO[Any, AwsError, HealthCheckTimeoutSeconds] = AwsError
      .unwrapOptionField("healthCheckTimeoutSeconds", healthCheckTimeoutSeconds)
    def getHealthyThresholdCount: ZIO[Any, AwsError, HealthyThresholdCount] =
      AwsError.unwrapOptionField("healthyThresholdCount", healthyThresholdCount)
    def getMatcher
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.Matcher.ReadOnly] =
      AwsError.unwrapOptionField("matcher", matcher)
    def getPath: ZIO[Any, AwsError, HealthCheckPath] =
      AwsError.unwrapOptionField("path", path)
    def getPort: ZIO[Any, AwsError, HealthCheckPort] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getProtocolVersion: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.HealthCheckProtocolVersion
    ] = AwsError.unwrapOptionField("protocolVersion", protocolVersion)
    def getUnhealthyThresholdCount
        : ZIO[Any, AwsError, UnhealthyThresholdCount] = AwsError
      .unwrapOptionField("unhealthyThresholdCount", unhealthyThresholdCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.HealthCheckConfig
  ) extends zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val healthCheckIntervalSeconds
        : Optional[HealthCheckIntervalSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheckIntervalSeconds())
      .map(value =>
        zio.aws.vpclattice.model.primitives.HealthCheckIntervalSeconds(value)
      )
    override val healthCheckTimeoutSeconds
        : Optional[HealthCheckTimeoutSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheckTimeoutSeconds())
      .map(value =>
        zio.aws.vpclattice.model.primitives.HealthCheckTimeoutSeconds(value)
      )
    override val healthyThresholdCount: Optional[HealthyThresholdCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthyThresholdCount())
        .map(value =>
          zio.aws.vpclattice.model.primitives.HealthyThresholdCount(value)
        )
    override val matcher: Optional[zio.aws.vpclattice.model.Matcher.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matcher())
        .map(value => zio.aws.vpclattice.model.Matcher.wrap(value))
    override val path: Optional[HealthCheckPath] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.vpclattice.model.primitives.HealthCheckPath(value))
    override val port: Optional[HealthCheckPort] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.vpclattice.model.primitives.HealthCheckPort(value))
    override val protocol
        : Optional[zio.aws.vpclattice.model.TargetGroupProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.vpclattice.model.TargetGroupProtocol.wrap(value))
    override val protocolVersion
        : Optional[zio.aws.vpclattice.model.HealthCheckProtocolVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolVersion())
        .map(value =>
          zio.aws.vpclattice.model.HealthCheckProtocolVersion.wrap(value)
        )
    override val unhealthyThresholdCount: Optional[UnhealthyThresholdCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unhealthyThresholdCount())
        .map(value =>
          zio.aws.vpclattice.model.primitives.UnhealthyThresholdCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.HealthCheckConfig
  ): zio.aws.vpclattice.model.HealthCheckConfig.ReadOnly = new Wrapper(impl)
}
