package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  HeaderMatchPrefix,
  HeaderMatchExact,
  HeaderMatchContains
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HeaderMatchType(
    contains: Optional[HeaderMatchContains] = Optional.Absent,
    exact: Optional[HeaderMatchExact] = Optional.Absent,
    prefix: Optional[HeaderMatchPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.HeaderMatchType = {
    import HeaderMatchType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.HeaderMatchType
      .builder()
      .optionallyWith(
        contains.map(value =>
          HeaderMatchContains.unwrap(value): java.lang.String
        )
      )(_.contains)
      .optionallyWith(
        exact.map(value => HeaderMatchExact.unwrap(value): java.lang.String)
      )(_.exact)
      .optionallyWith(
        prefix.map(value => HeaderMatchPrefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.HeaderMatchType.ReadOnly =
    zio.aws.vpclattice.model.HeaderMatchType.wrap(buildAwsValue())
}
object HeaderMatchType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.HeaderMatchType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.HeaderMatchType =
      zio.aws.vpclattice.model.HeaderMatchType(
        contains.map(value => value),
        exact.map(value => value),
        prefix.map(value => value)
      )
    def contains: Optional[HeaderMatchContains]
    def exact: Optional[HeaderMatchExact]
    def prefix: Optional[HeaderMatchPrefix]
    def getContains: ZIO[Any, AwsError, HeaderMatchContains] =
      AwsError.unwrapOptionField("contains", contains)
    def getExact: ZIO[Any, AwsError, HeaderMatchExact] =
      AwsError.unwrapOptionField("exact", exact)
    def getPrefix: ZIO[Any, AwsError, HeaderMatchPrefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.HeaderMatchType
  ) extends zio.aws.vpclattice.model.HeaderMatchType.ReadOnly {
    override val contains: Optional[HeaderMatchContains] = zio.aws.core.internal
      .optionalFromNullable(impl.contains())
      .map(value =>
        zio.aws.vpclattice.model.primitives.HeaderMatchContains(value)
      )
    override val exact: Optional[HeaderMatchExact] = zio.aws.core.internal
      .optionalFromNullable(impl.exact())
      .map(value => zio.aws.vpclattice.model.primitives.HeaderMatchExact(value))
    override val prefix: Optional[HeaderMatchPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value =>
        zio.aws.vpclattice.model.primitives.HeaderMatchPrefix(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.HeaderMatchType
  ): zio.aws.vpclattice.model.HeaderMatchType.ReadOnly = new Wrapper(impl)
}
