package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.HeaderMatchName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HeaderMatch(
    caseSensitive: Optional[Boolean] = Optional.Absent,
    `match`: zio.aws.vpclattice.model.HeaderMatchType,
    name: HeaderMatchName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.HeaderMatch = {
    import HeaderMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.HeaderMatch
      .builder()
      .optionallyWith(caseSensitive.map(value => value: java.lang.Boolean))(
        _.caseSensitive
      )
      .`match`(`match`.buildAwsValue())
      .name(HeaderMatchName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.HeaderMatch.ReadOnly =
    zio.aws.vpclattice.model.HeaderMatch.wrap(buildAwsValue())
}
object HeaderMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.HeaderMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.HeaderMatch =
      zio.aws.vpclattice.model.HeaderMatch(
        caseSensitive.map(value => value),
        `match`.asEditable,
        name
      )
    def caseSensitive: Optional[Boolean]
    def `match`: zio.aws.vpclattice.model.HeaderMatchType.ReadOnly
    def name: HeaderMatchName
    def getCaseSensitive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("caseSensitive", caseSensitive)
    def getMatch
        : ZIO[Any, Nothing, zio.aws.vpclattice.model.HeaderMatchType.ReadOnly] =
      ZIO.succeed(`match`)
    def getName: ZIO[Any, Nothing, HeaderMatchName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.HeaderMatch
  ) extends zio.aws.vpclattice.model.HeaderMatch.ReadOnly {
    override val caseSensitive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.caseSensitive())
      .map(value => value: Boolean)
    override val `match`: zio.aws.vpclattice.model.HeaderMatchType.ReadOnly =
      zio.aws.vpclattice.model.HeaderMatchType.wrap(impl.`match`())
    override val name: HeaderMatchName =
      zio.aws.vpclattice.model.primitives.HeaderMatchName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.HeaderMatch
  ): zio.aws.vpclattice.model.HeaderMatch.ReadOnly = new Wrapper(impl)
}
