package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ServiceArn,
  Timestamp,
  TargetGroupId,
  TargetGroupArn,
  TargetGroupName
}
import scala.jdk.CollectionConverters.*
final case class GetTargetGroupResponse(
    arn: Optional[TargetGroupArn] = Optional.Absent,
    config: Optional[zio.aws.vpclattice.model.TargetGroupConfig] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    failureCode: Optional[String] = Optional.Absent,
    failureMessage: Optional[String] = Optional.Absent,
    id: Optional[TargetGroupId] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    name: Optional[TargetGroupName] = Optional.Absent,
    serviceArns: Optional[Iterable[ServiceArn]] = Optional.Absent,
    status: Optional[zio.aws.vpclattice.model.TargetGroupStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.vpclattice.model.TargetGroupType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetTargetGroupResponse = {
    import GetTargetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetTargetGroupResponse
      .builder()
      .optionallyWith(
        arn.map(value => TargetGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(
        id.map(value => TargetGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => TargetGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        serviceArns.map(value =>
          value.map { item =>
            ServiceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.serviceArns)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetTargetGroupResponse.ReadOnly =
    zio.aws.vpclattice.model.GetTargetGroupResponse.wrap(buildAwsValue())
}
object GetTargetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetTargetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetTargetGroupResponse =
      zio.aws.vpclattice.model.GetTargetGroupResponse(
        arn.map(value => value),
        config.map(value => value.asEditable),
        createdAt.map(value => value),
        failureCode.map(value => value),
        failureMessage.map(value => value),
        id.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        serviceArns.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[TargetGroupArn]
    def config: Optional[zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly]
    def createdAt: Optional[Timestamp]
    def failureCode: Optional[String]
    def failureMessage: Optional[String]
    def id: Optional[TargetGroupId]
    def lastUpdatedAt: Optional[Timestamp]
    def name: Optional[TargetGroupName]
    def serviceArns: Optional[List[ServiceArn]]
    def status: Optional[zio.aws.vpclattice.model.TargetGroupStatus]
    def `type`: Optional[zio.aws.vpclattice.model.TargetGroupType]
    def getArn: ZIO[Any, AwsError, TargetGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getConfig: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly
    ] = AwsError.unwrapOptionField("config", config)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getId: ZIO[Any, AwsError, TargetGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, TargetGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getServiceArns: ZIO[Any, AwsError, List[ServiceArn]] =
      AwsError.unwrapOptionField("serviceArns", serviceArns)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetTargetGroupResponse
  ) extends zio.aws.vpclattice.model.GetTargetGroupResponse.ReadOnly {
    override val arn: Optional[TargetGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupArn(value))
    override val config
        : Optional[zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.config())
        .map(value => zio.aws.vpclattice.model.TargetGroupConfig.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val failureCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => value: String)
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
    override val id: Optional[TargetGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupId(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val name: Optional[TargetGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupName(value))
    override val serviceArns: Optional[List[ServiceArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.vpclattice.model.primitives.ServiceArn(item)
        }.toList
      )
    override val status: Optional[zio.aws.vpclattice.model.TargetGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.vpclattice.model.TargetGroupStatus.wrap(value))
    override val `type`: Optional[zio.aws.vpclattice.model.TargetGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.vpclattice.model.TargetGroupType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetTargetGroupResponse
  ): zio.aws.vpclattice.model.GetTargetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
