package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.TargetGroupIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTargetGroupRequest(
    targetGroupIdentifier: TargetGroupIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest = {
    import GetTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest
      .builder()
      .targetGroupIdentifier(
        TargetGroupIdentifier.unwrap(targetGroupIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetTargetGroupRequest.ReadOnly =
    zio.aws.vpclattice.model.GetTargetGroupRequest.wrap(buildAwsValue())
}
object GetTargetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetTargetGroupRequest =
      zio.aws.vpclattice.model.GetTargetGroupRequest(targetGroupIdentifier)
    def targetGroupIdentifier: TargetGroupIdentifier
    def getTargetGroupIdentifier: ZIO[Any, Nothing, TargetGroupIdentifier] =
      ZIO.succeed(targetGroupIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest
  ) extends zio.aws.vpclattice.model.GetTargetGroupRequest.ReadOnly {
    override val targetGroupIdentifier: TargetGroupIdentifier =
      zio.aws.vpclattice.model.primitives
        .TargetGroupIdentifier(impl.targetGroupIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest
  ): zio.aws.vpclattice.model.GetTargetGroupRequest.ReadOnly = new Wrapper(impl)
}
