package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ServiceId,
  ServiceArn,
  ServiceCustomDomainName,
  Timestamp,
  CertificateArn,
  FailureCode,
  FailureMessage,
  ServiceName
}
import scala.jdk.CollectionConverters.*
final case class GetServiceResponse(
    arn: Optional[ServiceArn] = Optional.Absent,
    authType: Optional[zio.aws.vpclattice.model.AuthType] = Optional.Absent,
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    customDomainName: Optional[ServiceCustomDomainName] = Optional.Absent,
    dnsEntry: Optional[zio.aws.vpclattice.model.DnsEntry] = Optional.Absent,
    failureCode: Optional[FailureCode] = Optional.Absent,
    failureMessage: Optional[FailureMessage] = Optional.Absent,
    id: Optional[ServiceId] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    name: Optional[ServiceName] = Optional.Absent,
    status: Optional[zio.aws.vpclattice.model.ServiceStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetServiceResponse = {
    import GetServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetServiceResponse
      .builder()
      .optionallyWith(
        arn.map(value => ServiceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        customDomainName.map(value =>
          ServiceCustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(dnsEntry.map(value => value.buildAwsValue()))(_.dnsEntry)
      .optionallyWith(
        failureCode.map(value => FailureCode.unwrap(value): java.lang.String)
      )(_.failureCode)
      .optionallyWith(
        failureMessage.map(value =>
          FailureMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .optionallyWith(
        id.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetServiceResponse.ReadOnly =
    zio.aws.vpclattice.model.GetServiceResponse.wrap(buildAwsValue())
}
object GetServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetServiceResponse =
      zio.aws.vpclattice.model.GetServiceResponse(
        arn.map(value => value),
        authType.map(value => value),
        certificateArn.map(value => value),
        createdAt.map(value => value),
        customDomainName.map(value => value),
        dnsEntry.map(value => value.asEditable),
        failureCode.map(value => value),
        failureMessage.map(value => value),
        id.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[ServiceArn]
    def authType: Optional[zio.aws.vpclattice.model.AuthType]
    def certificateArn: Optional[CertificateArn]
    def createdAt: Optional[Timestamp]
    def customDomainName: Optional[ServiceCustomDomainName]
    def dnsEntry: Optional[zio.aws.vpclattice.model.DnsEntry.ReadOnly]
    def failureCode: Optional[FailureCode]
    def failureMessage: Optional[FailureMessage]
    def id: Optional[ServiceId]
    def lastUpdatedAt: Optional[Timestamp]
    def name: Optional[ServiceName]
    def status: Optional[zio.aws.vpclattice.model.ServiceStatus]
    def getArn: ZIO[Any, AwsError, ServiceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthType: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCustomDomainName: ZIO[Any, AwsError, ServiceCustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getDnsEntry
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.DnsEntry.ReadOnly] =
      AwsError.unwrapOptionField("dnsEntry", dnsEntry)
    def getFailureCode: ZIO[Any, AwsError, FailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, FailureMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("id", id)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.vpclattice.model.ServiceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceResponse
  ) extends zio.aws.vpclattice.model.GetServiceResponse.ReadOnly {
    override val arn: Optional[ServiceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceArn(value))
    override val authType: Optional[zio.aws.vpclattice.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.vpclattice.model.AuthType.wrap(value))
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.vpclattice.model.primitives.CertificateArn(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val customDomainName: Optional[ServiceCustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceCustomDomainName(value)
        )
    override val dnsEntry
        : Optional[zio.aws.vpclattice.model.DnsEntry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsEntry())
        .map(value => zio.aws.vpclattice.model.DnsEntry.wrap(value))
    override val failureCode: Optional[FailureCode] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => zio.aws.vpclattice.model.primitives.FailureCode(value))
    override val failureMessage: Optional[FailureMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureMessage())
        .map(value => zio.aws.vpclattice.model.primitives.FailureMessage(value))
    override val id: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceId(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val name: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceName(value))
    override val status: Optional[zio.aws.vpclattice.model.ServiceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.vpclattice.model.ServiceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceResponse
  ): zio.aws.vpclattice.model.GetServiceResponse.ReadOnly = new Wrapper(impl)
}
