package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.ServiceIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetServiceRequest(serviceIdentifier: ServiceIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetServiceRequest = {
    import GetServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetServiceRequest
      .builder()
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetServiceRequest.ReadOnly =
    zio.aws.vpclattice.model.GetServiceRequest.wrap(buildAwsValue())
}
object GetServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetServiceRequest =
      zio.aws.vpclattice.model.GetServiceRequest(serviceIdentifier)
    def serviceIdentifier: ServiceIdentifier
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceRequest
  ) extends zio.aws.vpclattice.model.GetServiceRequest.ReadOnly {
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceRequest
  ): zio.aws.vpclattice.model.GetServiceRequest.ReadOnly = new Wrapper(impl)
}
