package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  VpcId,
  SecurityGroupId,
  ServiceNetworkVpcAssociationArn,
  AccountId,
  ServiceNetworkId,
  ServiceNetworkArn,
  Timestamp,
  ServiceNetworkVpcAssociationId,
  ServiceNetworkName
}
import scala.jdk.CollectionConverters.*
final case class GetServiceNetworkVpcAssociationResponse(
    arn: Optional[ServiceNetworkVpcAssociationArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[AccountId] = Optional.Absent,
    failureCode: Optional[String] = Optional.Absent,
    failureMessage: Optional[String] = Optional.Absent,
    id: Optional[ServiceNetworkVpcAssociationId] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    serviceNetworkArn: Optional[ServiceNetworkArn] = Optional.Absent,
    serviceNetworkId: Optional[ServiceNetworkId] = Optional.Absent,
    serviceNetworkName: Optional[ServiceNetworkName] = Optional.Absent,
    status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationResponse = {
    import GetServiceNetworkVpcAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationResponse
      .builder()
      .optionallyWith(
        arn.map(value =>
          ServiceNetworkVpcAssociationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(
        id.map(value =>
          ServiceNetworkVpcAssociationId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        serviceNetworkArn.map(value =>
          ServiceNetworkArn.unwrap(value): java.lang.String
        )
      )(_.serviceNetworkArn)
      .optionallyWith(
        serviceNetworkId.map(value =>
          ServiceNetworkId.unwrap(value): java.lang.String
        )
      )(_.serviceNetworkId)
      .optionallyWith(
        serviceNetworkName.map(value =>
          ServiceNetworkName.unwrap(value): java.lang.String
        )
      )(_.serviceNetworkName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.ReadOnly =
    zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse
      .wrap(buildAwsValue())
}
object GetServiceNetworkVpcAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse =
      zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        createdBy.map(value => value),
        failureCode.map(value => value),
        failureMessage.map(value => value),
        id.map(value => value),
        lastUpdatedAt.map(value => value),
        securityGroupIds.map(value => value),
        serviceNetworkArn.map(value => value),
        serviceNetworkId.map(value => value),
        serviceNetworkName.map(value => value),
        status.map(value => value),
        vpcId.map(value => value)
      )
    def arn: Optional[ServiceNetworkVpcAssociationArn]
    def createdAt: Optional[Timestamp]
    def createdBy: Optional[AccountId]
    def failureCode: Optional[String]
    def failureMessage: Optional[String]
    def id: Optional[ServiceNetworkVpcAssociationId]
    def lastUpdatedAt: Optional[Timestamp]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def serviceNetworkArn: Optional[ServiceNetworkArn]
    def serviceNetworkId: Optional[ServiceNetworkId]
    def serviceNetworkName: Optional[ServiceNetworkName]
    def status
        : Optional[zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus]
    def vpcId: Optional[VpcId]
    def getArn: ZIO[Any, AwsError, ServiceNetworkVpcAssociationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getId: ZIO[Any, AwsError, ServiceNetworkVpcAssociationId] =
      AwsError.unwrapOptionField("id", id)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getServiceNetworkArn: ZIO[Any, AwsError, ServiceNetworkArn] =
      AwsError.unwrapOptionField("serviceNetworkArn", serviceNetworkArn)
    def getServiceNetworkId: ZIO[Any, AwsError, ServiceNetworkId] =
      AwsError.unwrapOptionField("serviceNetworkId", serviceNetworkId)
    def getServiceNetworkName: ZIO[Any, AwsError, ServiceNetworkName] =
      AwsError.unwrapOptionField("serviceNetworkName", serviceNetworkName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationResponse
  ) extends zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.ReadOnly {
    override val arn: Optional[ServiceNetworkVpcAssociationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkVpcAssociationArn(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val createdBy: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.vpclattice.model.primitives.AccountId(value))
    override val failureCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => value: String)
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
    override val id: Optional[ServiceNetworkVpcAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkVpcAssociationId(value)
        )
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val serviceNetworkArn: Optional[ServiceNetworkArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNetworkArn())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceNetworkArn(value)
        )
    override val serviceNetworkId: Optional[ServiceNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNetworkId())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceNetworkId(value)
        )
    override val serviceNetworkName: Optional[ServiceNetworkName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNetworkName())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceNetworkName(value)
        )
    override val status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus.wrap(value)
      )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.vpclattice.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationResponse
  ): zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
