package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ServiceNetworkName,
  ServiceNetworkId,
  Timestamp,
  ServiceNetworkArn
}
import scala.jdk.CollectionConverters.*
final case class GetServiceNetworkResponse(
    arn: Optional[ServiceNetworkArn] = Optional.Absent,
    authType: Optional[zio.aws.vpclattice.model.AuthType] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    id: Optional[ServiceNetworkId] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    name: Optional[ServiceNetworkName] = Optional.Absent,
    numberOfAssociatedServices: Optional[Long] = Optional.Absent,
    numberOfAssociatedVPCs: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResponse = {
    import GetServiceNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResponse
      .builder()
      .optionallyWith(
        arn.map(value => ServiceNetworkArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        id.map(value => ServiceNetworkId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => ServiceNetworkName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        numberOfAssociatedServices.map(value => value: java.lang.Long)
      )(_.numberOfAssociatedServices)
      .optionallyWith(
        numberOfAssociatedVPCs.map(value => value: java.lang.Long)
      )(_.numberOfAssociatedVPCs)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetServiceNetworkResponse.ReadOnly =
    zio.aws.vpclattice.model.GetServiceNetworkResponse.wrap(buildAwsValue())
}
object GetServiceNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetServiceNetworkResponse =
      zio.aws.vpclattice.model.GetServiceNetworkResponse(
        arn.map(value => value),
        authType.map(value => value),
        createdAt.map(value => value),
        id.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        numberOfAssociatedServices.map(value => value),
        numberOfAssociatedVPCs.map(value => value)
      )
    def arn: Optional[ServiceNetworkArn]
    def authType: Optional[zio.aws.vpclattice.model.AuthType]
    def createdAt: Optional[Timestamp]
    def id: Optional[ServiceNetworkId]
    def lastUpdatedAt: Optional[Timestamp]
    def name: Optional[ServiceNetworkName]
    def numberOfAssociatedServices: Optional[Long]
    def numberOfAssociatedVPCs: Optional[Long]
    def getArn: ZIO[Any, AwsError, ServiceNetworkArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthType: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getId: ZIO[Any, AwsError, ServiceNetworkId] =
      AwsError.unwrapOptionField("id", id)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, ServiceNetworkName] =
      AwsError.unwrapOptionField("name", name)
    def getNumberOfAssociatedServices: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "numberOfAssociatedServices",
        numberOfAssociatedServices
      )
    def getNumberOfAssociatedVPCs: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("numberOfAssociatedVPCs", numberOfAssociatedVPCs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResponse
  ) extends zio.aws.vpclattice.model.GetServiceNetworkResponse.ReadOnly {
    override val arn: Optional[ServiceNetworkArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.vpclattice.model.primitives.ServiceNetworkArn(value)
      )
    override val authType: Optional[zio.aws.vpclattice.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.vpclattice.model.AuthType.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val id: Optional[ServiceNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceNetworkId(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val name: Optional[ServiceNetworkName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.vpclattice.model.primitives.ServiceNetworkName(value)
      )
    override val numberOfAssociatedServices: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfAssociatedServices())
        .map(value => value: Long)
    override val numberOfAssociatedVPCs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfAssociatedVPCs())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResponse
  ): zio.aws.vpclattice.model.GetServiceNetworkResponse.ReadOnly = new Wrapper(
    impl
  )
}
