package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.ServiceNetworkIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetServiceNetworkRequest(
    serviceNetworkIdentifier: ServiceNetworkIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest = {
    import GetServiceNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest
      .builder()
      .serviceNetworkIdentifier(
        ServiceNetworkIdentifier.unwrap(
          serviceNetworkIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetServiceNetworkRequest.ReadOnly =
    zio.aws.vpclattice.model.GetServiceNetworkRequest.wrap(buildAwsValue())
}
object GetServiceNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetServiceNetworkRequest =
      zio.aws.vpclattice.model
        .GetServiceNetworkRequest(serviceNetworkIdentifier)
    def serviceNetworkIdentifier: ServiceNetworkIdentifier
    def getServiceNetworkIdentifier
        : ZIO[Any, Nothing, ServiceNetworkIdentifier] =
      ZIO.succeed(serviceNetworkIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest
  ) extends zio.aws.vpclattice.model.GetServiceNetworkRequest.ReadOnly {
    override val serviceNetworkIdentifier: ServiceNetworkIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceNetworkIdentifier(impl.serviceNetworkIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest
  ): zio.aws.vpclattice.model.GetServiceNetworkRequest.ReadOnly = new Wrapper(
    impl
  )
}
