package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.PolicyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetResourcePolicyResponse(
    policy: Optional[PolicyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => PolicyString.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.vpclattice.model.GetResourcePolicyResponse.wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetResourcePolicyResponse =
      zio.aws.vpclattice.model
        .GetResourcePolicyResponse(policy.map(value => value))
    def policy: Optional[PolicyString]
    def getPolicy: ZIO[Any, AwsError, PolicyString] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyResponse
  ) extends zio.aws.vpclattice.model.GetResourcePolicyResponse.ReadOnly {
    override val policy: Optional[PolicyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.vpclattice.model.primitives.PolicyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyResponse
  ): zio.aws.vpclattice.model.GetResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
