package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetResourcePolicyRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest = {
    import GetResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetResourcePolicyRequest.ReadOnly =
    zio.aws.vpclattice.model.GetResourcePolicyRequest.wrap(buildAwsValue())
}
object GetResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetResourcePolicyRequest =
      zio.aws.vpclattice.model.GetResourcePolicyRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest
  ) extends zio.aws.vpclattice.model.GetResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.vpclattice.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest
  ): zio.aws.vpclattice.model.GetResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
