package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  ServiceId,
  ServiceArn,
  Timestamp,
  Port,
  ListenerArn,
  ListenerId,
  ListenerName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetListenerResponse(
    arn: Optional[ListenerArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    defaultAction: Optional[zio.aws.vpclattice.model.RuleAction] =
      Optional.Absent,
    id: Optional[ListenerId] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    name: Optional[ListenerName] = Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    protocol: Optional[zio.aws.vpclattice.model.ListenerProtocol] =
      Optional.Absent,
    serviceArn: Optional[ServiceArn] = Optional.Absent,
    serviceId: Optional[ServiceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetListenerResponse = {
    import GetListenerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetListenerResponse
      .builder()
      .optionallyWith(
        arn.map(value => ListenerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(defaultAction.map(value => value.buildAwsValue()))(
        _.defaultAction
      )
      .optionallyWith(
        id.map(value => ListenerId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => ListenerName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        serviceArn.map(value => ServiceArn.unwrap(value): java.lang.String)
      )(_.serviceArn)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetListenerResponse.ReadOnly =
    zio.aws.vpclattice.model.GetListenerResponse.wrap(buildAwsValue())
}
object GetListenerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetListenerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetListenerResponse =
      zio.aws.vpclattice.model.GetListenerResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        defaultAction.map(value => value.asEditable),
        id.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        port.map(value => value),
        protocol.map(value => value),
        serviceArn.map(value => value),
        serviceId.map(value => value)
      )
    def arn: Optional[ListenerArn]
    def createdAt: Optional[Timestamp]
    def defaultAction: Optional[zio.aws.vpclattice.model.RuleAction.ReadOnly]
    def id: Optional[ListenerId]
    def lastUpdatedAt: Optional[Timestamp]
    def name: Optional[ListenerName]
    def port: Optional[Port]
    def protocol: Optional[zio.aws.vpclattice.model.ListenerProtocol]
    def serviceArn: Optional[ServiceArn]
    def serviceId: Optional[ServiceId]
    def getArn: ZIO[Any, AwsError, ListenerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDefaultAction
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      AwsError.unwrapOptionField("defaultAction", defaultAction)
    def getId: ZIO[Any, AwsError, ListenerId] =
      AwsError.unwrapOptionField("id", id)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, ListenerName] =
      AwsError.unwrapOptionField("name", name)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.ListenerProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getServiceArn: ZIO[Any, AwsError, ServiceArn] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetListenerResponse
  ) extends zio.aws.vpclattice.model.GetListenerResponse.ReadOnly {
    override val arn: Optional[ListenerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.ListenerArn(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val defaultAction
        : Optional[zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultAction())
        .map(value => zio.aws.vpclattice.model.RuleAction.wrap(value))
    override val id: Optional[ListenerId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.ListenerId(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val name: Optional[ListenerName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.ListenerName(value))
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.vpclattice.model.primitives.Port(value))
    override val protocol: Optional[zio.aws.vpclattice.model.ListenerProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.vpclattice.model.ListenerProtocol.wrap(value))
    override val serviceArn: Optional[ServiceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArn())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceArn(value))
    override val serviceId: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetListenerResponse
  ): zio.aws.vpclattice.model.GetListenerResponse.ReadOnly = new Wrapper(impl)
}
