package zio.aws.vpclattice.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{AuthPolicyString, Timestamp}
import scala.jdk.CollectionConverters.*
final case class GetAuthPolicyResponse(
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    policy: Optional[AuthPolicyString] = Optional.Absent,
    state: Optional[zio.aws.vpclattice.model.AuthPolicyState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyResponse = {
    import GetAuthPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyResponse
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        policy.map(value => AuthPolicyString.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.GetAuthPolicyResponse.ReadOnly =
    zio.aws.vpclattice.model.GetAuthPolicyResponse.wrap(buildAwsValue())
}
object GetAuthPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.GetAuthPolicyResponse =
      zio.aws.vpclattice.model.GetAuthPolicyResponse(
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        policy.map(value => value),
        state.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def policy: Optional[AuthPolicyString]
    def state: Optional[zio.aws.vpclattice.model.AuthPolicyState]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getPolicy: ZIO[Any, AwsError, AuthPolicyString] =
      AwsError.unwrapOptionField("policy", policy)
    def getState: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthPolicyState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyResponse
  ) extends zio.aws.vpclattice.model.GetAuthPolicyResponse.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.vpclattice.model.primitives.Timestamp(value))
    override val policy: Optional[AuthPolicyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.vpclattice.model.primitives.AuthPolicyString(value))
    override val state: Optional[zio.aws.vpclattice.model.AuthPolicyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.vpclattice.model.AuthPolicyState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyResponse
  ): zio.aws.vpclattice.model.GetAuthPolicyResponse.ReadOnly = new Wrapper(impl)
}
