package zio.aws.vpclattice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ForwardAction(
    targetGroups: Iterable[zio.aws.vpclattice.model.WeightedTargetGroup]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.ForwardAction = {
    import ForwardAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.ForwardAction
      .builder()
      .targetGroups(targetGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.ForwardAction.ReadOnly =
    zio.aws.vpclattice.model.ForwardAction.wrap(buildAwsValue())
}
object ForwardAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.ForwardAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.ForwardAction =
      zio.aws.vpclattice.model.ForwardAction(targetGroups.map { item =>
        item.asEditable
      })
    def targetGroups
        : List[zio.aws.vpclattice.model.WeightedTargetGroup.ReadOnly]
    def getTargetGroups: ZIO[Any, Nothing, List[
      zio.aws.vpclattice.model.WeightedTargetGroup.ReadOnly
    ]] = ZIO.succeed(targetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.ForwardAction
  ) extends zio.aws.vpclattice.model.ForwardAction.ReadOnly {
    override val targetGroups
        : List[zio.aws.vpclattice.model.WeightedTargetGroup.ReadOnly] = impl
      .targetGroups()
      .asScala
      .map { item =>
        zio.aws.vpclattice.model.WeightedTargetGroup.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.ForwardAction
  ): zio.aws.vpclattice.model.ForwardAction.ReadOnly = new Wrapper(impl)
}
