package zio.aws.vpclattice.model
import java.lang.Integer
import zio.aws.vpclattice.model.primitives.HttpStatusCode
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FixedResponseAction(statusCode: HttpStatusCode) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.FixedResponseAction = {
    import FixedResponseAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.FixedResponseAction
      .builder()
      .statusCode(HttpStatusCode.unwrap(statusCode): Integer)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.FixedResponseAction.ReadOnly =
    zio.aws.vpclattice.model.FixedResponseAction.wrap(buildAwsValue())
}
object FixedResponseAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.FixedResponseAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.FixedResponseAction =
      zio.aws.vpclattice.model.FixedResponseAction(statusCode)
    def statusCode: HttpStatusCode
    def getStatusCode: ZIO[Any, Nothing, HttpStatusCode] =
      ZIO.succeed(statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.FixedResponseAction
  ) extends zio.aws.vpclattice.model.FixedResponseAction.ReadOnly {
    override val statusCode: HttpStatusCode =
      zio.aws.vpclattice.model.primitives.HttpStatusCode(impl.statusCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.FixedResponseAction
  ): zio.aws.vpclattice.model.FixedResponseAction.ReadOnly = new Wrapper(impl)
}
