package zio.aws.vpclattice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DnsEntry(
    domainName: Optional[String] = Optional.Absent,
    hostedZoneId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DnsEntry = {
    import DnsEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DnsEntry
      .builder()
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.DnsEntry.ReadOnly =
    zio.aws.vpclattice.model.DnsEntry.wrap(buildAwsValue())
}
object DnsEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DnsEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DnsEntry =
      zio.aws.vpclattice.model.DnsEntry(
        domainName.map(value => value),
        hostedZoneId.map(value => value)
      )
    def domainName: Optional[String]
    def hostedZoneId: Optional[String]
    def getDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DnsEntry
  ) extends zio.aws.vpclattice.model.DnsEntry.ReadOnly {
    override val domainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => value: String)
    override val hostedZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DnsEntry
  ): zio.aws.vpclattice.model.DnsEntry.ReadOnly = new Wrapper(impl)
}
