package zio.aws.vpclattice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeregisterTargetsResponse(
    successful: Optional[Iterable[zio.aws.vpclattice.model.Target]] =
      Optional.Absent,
    unsuccessful: Optional[Iterable[zio.aws.vpclattice.model.TargetFailure]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsResponse = {
    import DeregisterTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsResponse
      .builder()
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .optionallyWith(
        unsuccessful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessful)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.DeregisterTargetsResponse.ReadOnly =
    zio.aws.vpclattice.model.DeregisterTargetsResponse.wrap(buildAwsValue())
}
object DeregisterTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DeregisterTargetsResponse =
      zio.aws.vpclattice.model.DeregisterTargetsResponse(
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successful: Optional[List[zio.aws.vpclattice.model.Target.ReadOnly]]
    def unsuccessful
        : Optional[List[zio.aws.vpclattice.model.TargetFailure.ReadOnly]]
    def getSuccessful
        : ZIO[Any, AwsError, List[zio.aws.vpclattice.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("successful", successful)
    def getUnsuccessful: ZIO[Any, AwsError, List[
      zio.aws.vpclattice.model.TargetFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("unsuccessful", unsuccessful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsResponse
  ) extends zio.aws.vpclattice.model.DeregisterTargetsResponse.ReadOnly {
    override val successful
        : Optional[List[zio.aws.vpclattice.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successful())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.Target.wrap(item)
          }.toList
        )
    override val unsuccessful
        : Optional[List[zio.aws.vpclattice.model.TargetFailure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unsuccessful())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.TargetFailure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsResponse
  ): zio.aws.vpclattice.model.DeregisterTargetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
