package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{TargetGroupId, TargetGroupArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteTargetGroupResponse(
    arn: Optional[TargetGroupArn] = Optional.Absent,
    id: Optional[TargetGroupId] = Optional.Absent,
    status: Optional[zio.aws.vpclattice.model.TargetGroupStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupResponse = {
    import DeleteTargetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupResponse
      .builder()
      .optionallyWith(
        arn.map(value => TargetGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => TargetGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.DeleteTargetGroupResponse.ReadOnly =
    zio.aws.vpclattice.model.DeleteTargetGroupResponse.wrap(buildAwsValue())
}
object DeleteTargetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DeleteTargetGroupResponse =
      zio.aws.vpclattice.model.DeleteTargetGroupResponse(
        arn.map(value => value),
        id.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[TargetGroupArn]
    def id: Optional[TargetGroupId]
    def status: Optional[zio.aws.vpclattice.model.TargetGroupStatus]
    def getArn: ZIO[Any, AwsError, TargetGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, TargetGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.TargetGroupStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupResponse
  ) extends zio.aws.vpclattice.model.DeleteTargetGroupResponse.ReadOnly {
    override val arn: Optional[TargetGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupArn(value))
    override val id: Optional[TargetGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.TargetGroupId(value))
    override val status: Optional[zio.aws.vpclattice.model.TargetGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.vpclattice.model.TargetGroupStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupResponse
  ): zio.aws.vpclattice.model.DeleteTargetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
