package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.TargetGroupIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTargetGroupRequest(
    targetGroupIdentifier: TargetGroupIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest = {
    import DeleteTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest
      .builder()
      .targetGroupIdentifier(
        TargetGroupIdentifier.unwrap(targetGroupIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.DeleteTargetGroupRequest.ReadOnly =
    zio.aws.vpclattice.model.DeleteTargetGroupRequest.wrap(buildAwsValue())
}
object DeleteTargetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DeleteTargetGroupRequest =
      zio.aws.vpclattice.model.DeleteTargetGroupRequest(targetGroupIdentifier)
    def targetGroupIdentifier: TargetGroupIdentifier
    def getTargetGroupIdentifier: ZIO[Any, Nothing, TargetGroupIdentifier] =
      ZIO.succeed(targetGroupIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest
  ) extends zio.aws.vpclattice.model.DeleteTargetGroupRequest.ReadOnly {
    override val targetGroupIdentifier: TargetGroupIdentifier =
      zio.aws.vpclattice.model.primitives
        .TargetGroupIdentifier(impl.targetGroupIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest
  ): zio.aws.vpclattice.model.DeleteTargetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
