package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{ServiceName, ServiceId, ServiceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteServiceResponse(
    arn: Optional[ServiceArn] = Optional.Absent,
    id: Optional[ServiceId] = Optional.Absent,
    name: Optional[ServiceName] = Optional.Absent,
    status: Optional[zio.aws.vpclattice.model.ServiceStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteServiceResponse = {
    import DeleteServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceResponse
      .builder()
      .optionallyWith(
        arn.map(value => ServiceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.DeleteServiceResponse.ReadOnly =
    zio.aws.vpclattice.model.DeleteServiceResponse.wrap(buildAwsValue())
}
object DeleteServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DeleteServiceResponse =
      zio.aws.vpclattice.model.DeleteServiceResponse(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[ServiceArn]
    def id: Optional[ServiceId]
    def name: Optional[ServiceName]
    def status: Optional[zio.aws.vpclattice.model.ServiceStatus]
    def getArn: ZIO[Any, AwsError, ServiceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.vpclattice.model.ServiceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceResponse
  ) extends zio.aws.vpclattice.model.DeleteServiceResponse.ReadOnly {
    override val arn: Optional[ServiceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceArn(value))
    override val id: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceId(value))
    override val name: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceName(value))
    override val status: Optional[zio.aws.vpclattice.model.ServiceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.vpclattice.model.ServiceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceResponse
  ): zio.aws.vpclattice.model.DeleteServiceResponse.ReadOnly = new Wrapper(impl)
}
