package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.ServiceIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServiceRequest(serviceIdentifier: ServiceIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest = {
    import DeleteServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest
      .builder()
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.DeleteServiceRequest.ReadOnly =
    zio.aws.vpclattice.model.DeleteServiceRequest.wrap(buildAwsValue())
}
object DeleteServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DeleteServiceRequest =
      zio.aws.vpclattice.model.DeleteServiceRequest(serviceIdentifier)
    def serviceIdentifier: ServiceIdentifier
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest
  ) extends zio.aws.vpclattice.model.DeleteServiceRequest.ReadOnly {
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest
  ): zio.aws.vpclattice.model.DeleteServiceRequest.ReadOnly = new Wrapper(impl)
}
