package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceNetworkVpcAssociationId,
  ServiceNetworkVpcAssociationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteServiceNetworkVpcAssociationResponse(
    arn: Optional[ServiceNetworkVpcAssociationArn] = Optional.Absent,
    id: Optional[ServiceNetworkVpcAssociationId] = Optional.Absent,
    status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse = {
    import DeleteServiceNetworkVpcAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse
      .builder()
      .optionallyWith(
        arn.map(value =>
          ServiceNetworkVpcAssociationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        id.map(value =>
          ServiceNetworkVpcAssociationId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.ReadOnly =
    zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse
      .wrap(buildAwsValue())
}
object DeleteServiceNetworkVpcAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse =
      zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse(
        arn.map(value => value),
        id.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[ServiceNetworkVpcAssociationArn]
    def id: Optional[ServiceNetworkVpcAssociationId]
    def status
        : Optional[zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus]
    def getArn: ZIO[Any, AwsError, ServiceNetworkVpcAssociationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ServiceNetworkVpcAssociationId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse
  ) extends zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.ReadOnly {
    override val arn: Optional[ServiceNetworkVpcAssociationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkVpcAssociationArn(value)
        )
    override val id: Optional[ServiceNetworkVpcAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkVpcAssociationId(value)
        )
    override val status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse
  ): zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
