package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceNetworkServiceAssociationIdentifier,
  ServiceNetworkServiceAssociationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteServiceNetworkServiceAssociationResponse(
    arn: Optional[ServiceNetworkServiceAssociationArn] = Optional.Absent,
    id: Optional[ServiceNetworkServiceAssociationIdentifier] = Optional.Absent,
    status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse = {
    import DeleteServiceNetworkServiceAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse
      .builder()
      .optionallyWith(
        arn.map(value =>
          ServiceNetworkServiceAssociationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        id.map(value =>
          ServiceNetworkServiceAssociationIdentifier.unwrap(
            value
          ): java.lang.String
        )
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.ReadOnly =
    zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse
      .wrap(buildAwsValue())
}
object DeleteServiceNetworkServiceAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse =
      zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse(
        arn.map(value => value),
        id.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[ServiceNetworkServiceAssociationArn]
    def id: Optional[ServiceNetworkServiceAssociationIdentifier]
    def status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ]
    def getArn: ZIO[Any, AwsError, ServiceNetworkServiceAssociationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ServiceNetworkServiceAssociationIdentifier] =
      AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse
  ) extends zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.ReadOnly {
    override val arn: Optional[ServiceNetworkServiceAssociationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkServiceAssociationArn(value)
        )
    override val id: Optional[ServiceNetworkServiceAssociationIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkServiceAssociationIdentifier(value)
        )
    override val status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse
  ): zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
