package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.ServiceNetworkIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServiceNetworkRequest(
    serviceNetworkIdentifier: ServiceNetworkIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest = {
    import DeleteServiceNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest
      .builder()
      .serviceNetworkIdentifier(
        ServiceNetworkIdentifier.unwrap(
          serviceNetworkIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.DeleteServiceNetworkRequest.ReadOnly =
    zio.aws.vpclattice.model.DeleteServiceNetworkRequest.wrap(buildAwsValue())
}
object DeleteServiceNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DeleteServiceNetworkRequest =
      zio.aws.vpclattice.model
        .DeleteServiceNetworkRequest(serviceNetworkIdentifier)
    def serviceNetworkIdentifier: ServiceNetworkIdentifier
    def getServiceNetworkIdentifier
        : ZIO[Any, Nothing, ServiceNetworkIdentifier] =
      ZIO.succeed(serviceNetworkIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest
  ) extends zio.aws.vpclattice.model.DeleteServiceNetworkRequest.ReadOnly {
    override val serviceNetworkIdentifier: ServiceNetworkIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceNetworkIdentifier(impl.serviceNetworkIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest
  ): zio.aws.vpclattice.model.DeleteServiceNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
