package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceIdentifier,
  RuleIdentifier,
  ListenerIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRuleRequest(
    listenerIdentifier: ListenerIdentifier,
    ruleIdentifier: RuleIdentifier,
    serviceIdentifier: ServiceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest = {
    import DeleteRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest
      .builder()
      .listenerIdentifier(
        ListenerIdentifier.unwrap(listenerIdentifier): java.lang.String
      )
      .ruleIdentifier(RuleIdentifier.unwrap(ruleIdentifier): java.lang.String)
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.DeleteRuleRequest.ReadOnly =
    zio.aws.vpclattice.model.DeleteRuleRequest.wrap(buildAwsValue())
}
object DeleteRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DeleteRuleRequest =
      zio.aws.vpclattice.model.DeleteRuleRequest(
        listenerIdentifier,
        ruleIdentifier,
        serviceIdentifier
      )
    def listenerIdentifier: ListenerIdentifier
    def ruleIdentifier: RuleIdentifier
    def serviceIdentifier: ServiceIdentifier
    def getListenerIdentifier: ZIO[Any, Nothing, ListenerIdentifier] =
      ZIO.succeed(listenerIdentifier)
    def getRuleIdentifier: ZIO[Any, Nothing, RuleIdentifier] =
      ZIO.succeed(ruleIdentifier)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest
  ) extends zio.aws.vpclattice.model.DeleteRuleRequest.ReadOnly {
    override val listenerIdentifier: ListenerIdentifier =
      zio.aws.vpclattice.model.primitives
        .ListenerIdentifier(impl.listenerIdentifier())
    override val ruleIdentifier: RuleIdentifier =
      zio.aws.vpclattice.model.primitives.RuleIdentifier(impl.ruleIdentifier())
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest
  ): zio.aws.vpclattice.model.DeleteRuleRequest.ReadOnly = new Wrapper(impl)
}
