package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceIdentifier,
  ListenerIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteListenerRequest(
    listenerIdentifier: ListenerIdentifier,
    serviceIdentifier: ServiceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest = {
    import DeleteListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest
      .builder()
      .listenerIdentifier(
        ListenerIdentifier.unwrap(listenerIdentifier): java.lang.String
      )
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.DeleteListenerRequest.ReadOnly =
    zio.aws.vpclattice.model.DeleteListenerRequest.wrap(buildAwsValue())
}
object DeleteListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.DeleteListenerRequest =
      zio.aws.vpclattice.model
        .DeleteListenerRequest(listenerIdentifier, serviceIdentifier)
    def listenerIdentifier: ListenerIdentifier
    def serviceIdentifier: ServiceIdentifier
    def getListenerIdentifier: ZIO[Any, Nothing, ListenerIdentifier] =
      ZIO.succeed(listenerIdentifier)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest
  ) extends zio.aws.vpclattice.model.DeleteListenerRequest.ReadOnly {
    override val listenerIdentifier: ListenerIdentifier =
      zio.aws.vpclattice.model.primitives
        .ListenerIdentifier(impl.listenerIdentifier())
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest
  ): zio.aws.vpclattice.model.DeleteListenerRequest.ReadOnly = new Wrapper(impl)
}
