package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.AccessLogSubscriptionIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAccessLogSubscriptionRequest(
    accessLogSubscriptionIdentifier: AccessLogSubscriptionIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest = {
    import DeleteAccessLogSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest
      .builder()
      .accessLogSubscriptionIdentifier(
        AccessLogSubscriptionIdentifier.unwrap(
          accessLogSubscriptionIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.DeleteAccessLogSubscriptionRequest.ReadOnly =
    zio.aws.vpclattice.model.DeleteAccessLogSubscriptionRequest
      .wrap(buildAwsValue())
}
object DeleteAccessLogSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.DeleteAccessLogSubscriptionRequest =
      zio.aws.vpclattice.model
        .DeleteAccessLogSubscriptionRequest(accessLogSubscriptionIdentifier)
    def accessLogSubscriptionIdentifier: AccessLogSubscriptionIdentifier
    def getAccessLogSubscriptionIdentifier
        : ZIO[Any, Nothing, AccessLogSubscriptionIdentifier] =
      ZIO.succeed(accessLogSubscriptionIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest
  ) extends zio.aws.vpclattice.model.DeleteAccessLogSubscriptionRequest.ReadOnly {
    override val accessLogSubscriptionIdentifier
        : AccessLogSubscriptionIdentifier = zio.aws.vpclattice.model.primitives
      .AccessLogSubscriptionIdentifier(impl.accessLogSubscriptionIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest
  ): zio.aws.vpclattice.model.DeleteAccessLogSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
