package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  TagValue,
  TagKey,
  TargetGroupName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTargetGroupRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    config: Optional[zio.aws.vpclattice.model.TargetGroupConfig] =
      Optional.Absent,
    name: TargetGroupName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: zio.aws.vpclattice.model.TargetGroupType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest = {
    import CreateTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .name(TargetGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.CreateTargetGroupRequest.ReadOnly =
    zio.aws.vpclattice.model.CreateTargetGroupRequest.wrap(buildAwsValue())
}
object CreateTargetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.CreateTargetGroupRequest =
      zio.aws.vpclattice.model.CreateTargetGroupRequest(
        clientToken.map(value => value),
        config.map(value => value.asEditable),
        name,
        tags.map(value => value),
        `type`
      )
    def clientToken: Optional[ClientToken]
    def config: Optional[zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly]
    def name: TargetGroupName
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: zio.aws.vpclattice.model.TargetGroupType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getConfig: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly
    ] = AwsError.unwrapOptionField("config", config)
    def getName: ZIO[Any, Nothing, TargetGroupName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.vpclattice.model.TargetGroupType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest
  ) extends zio.aws.vpclattice.model.CreateTargetGroupRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.vpclattice.model.primitives.ClientToken(value))
    override val config
        : Optional[zio.aws.vpclattice.model.TargetGroupConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.config())
        .map(value => zio.aws.vpclattice.model.TargetGroupConfig.wrap(value))
    override val name: TargetGroupName =
      zio.aws.vpclattice.model.primitives.TargetGroupName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.vpclattice.model.primitives.TagKey(
              key
            ) -> zio.aws.vpclattice.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: zio.aws.vpclattice.model.TargetGroupType =
      zio.aws.vpclattice.model.TargetGroupType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest
  ): zio.aws.vpclattice.model.CreateTargetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
