package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceId,
  ServiceArn,
  ServiceCustomDomainName,
  CertificateArn,
  ServiceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceResponse(
    arn: Optional[ServiceArn] = Optional.Absent,
    authType: Optional[zio.aws.vpclattice.model.AuthType] = Optional.Absent,
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    customDomainName: Optional[ServiceCustomDomainName] = Optional.Absent,
    dnsEntry: Optional[zio.aws.vpclattice.model.DnsEntry] = Optional.Absent,
    id: Optional[ServiceId] = Optional.Absent,
    name: Optional[ServiceName] = Optional.Absent,
    status: Optional[zio.aws.vpclattice.model.ServiceStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateServiceResponse = {
    import CreateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateServiceResponse
      .builder()
      .optionallyWith(
        arn.map(value => ServiceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        customDomainName.map(value =>
          ServiceCustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(dnsEntry.map(value => value.buildAwsValue()))(_.dnsEntry)
      .optionallyWith(
        id.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.CreateServiceResponse.ReadOnly =
    zio.aws.vpclattice.model.CreateServiceResponse.wrap(buildAwsValue())
}
object CreateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.CreateServiceResponse =
      zio.aws.vpclattice.model.CreateServiceResponse(
        arn.map(value => value),
        authType.map(value => value),
        certificateArn.map(value => value),
        customDomainName.map(value => value),
        dnsEntry.map(value => value.asEditable),
        id.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[ServiceArn]
    def authType: Optional[zio.aws.vpclattice.model.AuthType]
    def certificateArn: Optional[CertificateArn]
    def customDomainName: Optional[ServiceCustomDomainName]
    def dnsEntry: Optional[zio.aws.vpclattice.model.DnsEntry.ReadOnly]
    def id: Optional[ServiceId]
    def name: Optional[ServiceName]
    def status: Optional[zio.aws.vpclattice.model.ServiceStatus]
    def getArn: ZIO[Any, AwsError, ServiceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthType: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCustomDomainName: ZIO[Any, AwsError, ServiceCustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getDnsEntry
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.DnsEntry.ReadOnly] =
      AwsError.unwrapOptionField("dnsEntry", dnsEntry)
    def getId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.vpclattice.model.ServiceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceResponse
  ) extends zio.aws.vpclattice.model.CreateServiceResponse.ReadOnly {
    override val arn: Optional[ServiceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceArn(value))
    override val authType: Optional[zio.aws.vpclattice.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.vpclattice.model.AuthType.wrap(value))
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.vpclattice.model.primitives.CertificateArn(value))
    override val customDomainName: Optional[ServiceCustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceCustomDomainName(value)
        )
    override val dnsEntry
        : Optional[zio.aws.vpclattice.model.DnsEntry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsEntry())
        .map(value => zio.aws.vpclattice.model.DnsEntry.wrap(value))
    override val id: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceId(value))
    override val name: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.ServiceName(value))
    override val status: Optional[zio.aws.vpclattice.model.ServiceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.vpclattice.model.ServiceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceResponse
  ): zio.aws.vpclattice.model.CreateServiceResponse.ReadOnly = new Wrapper(impl)
}
