package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceCustomDomainName,
  TagValue,
  CertificateArn,
  ClientToken,
  ServiceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceRequest(
    authType: Optional[zio.aws.vpclattice.model.AuthType] = Optional.Absent,
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    customDomainName: Optional[ServiceCustomDomainName] = Optional.Absent,
    name: ServiceName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest = {
    import CreateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest
      .builder()
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        customDomainName.map(value =>
          ServiceCustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .name(ServiceName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.CreateServiceRequest.ReadOnly =
    zio.aws.vpclattice.model.CreateServiceRequest.wrap(buildAwsValue())
}
object CreateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.CreateServiceRequest =
      zio.aws.vpclattice.model.CreateServiceRequest(
        authType.map(value => value),
        certificateArn.map(value => value),
        clientToken.map(value => value),
        customDomainName.map(value => value),
        name,
        tags.map(value => value)
      )
    def authType: Optional[zio.aws.vpclattice.model.AuthType]
    def certificateArn: Optional[CertificateArn]
    def clientToken: Optional[ClientToken]
    def customDomainName: Optional[ServiceCustomDomainName]
    def name: ServiceName
    def tags: Optional[Map[TagKey, TagValue]]
    def getAuthType: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCustomDomainName: ZIO[Any, AwsError, ServiceCustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getName: ZIO[Any, Nothing, ServiceName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest
  ) extends zio.aws.vpclattice.model.CreateServiceRequest.ReadOnly {
    override val authType: Optional[zio.aws.vpclattice.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.vpclattice.model.AuthType.wrap(value))
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.vpclattice.model.primitives.CertificateArn(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.vpclattice.model.primitives.ClientToken(value))
    override val customDomainName: Optional[ServiceCustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceCustomDomainName(value)
        )
    override val name: ServiceName =
      zio.aws.vpclattice.model.primitives.ServiceName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.vpclattice.model.primitives.TagKey(
              key
            ) -> zio.aws.vpclattice.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest
  ): zio.aws.vpclattice.model.CreateServiceRequest.ReadOnly = new Wrapper(impl)
}
