package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  SecurityGroupId,
  ServiceNetworkVpcAssociationId,
  AccountId,
  ServiceNetworkVpcAssociationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceNetworkVpcAssociationResponse(
    arn: Optional[ServiceNetworkVpcAssociationArn] = Optional.Absent,
    createdBy: Optional[AccountId] = Optional.Absent,
    id: Optional[ServiceNetworkVpcAssociationId] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationResponse = {
    import CreateServiceNetworkVpcAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationResponse
      .builder()
      .optionallyWith(
        arn.map(value =>
          ServiceNetworkVpcAssociationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        createdBy.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        id.map(value =>
          ServiceNetworkVpcAssociationId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.ReadOnly =
    zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse
      .wrap(buildAwsValue())
}
object CreateServiceNetworkVpcAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse =
      zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse(
        arn.map(value => value),
        createdBy.map(value => value),
        id.map(value => value),
        securityGroupIds.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[ServiceNetworkVpcAssociationArn]
    def createdBy: Optional[AccountId]
    def id: Optional[ServiceNetworkVpcAssociationId]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def status
        : Optional[zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus]
    def getArn: ZIO[Any, AwsError, ServiceNetworkVpcAssociationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedBy: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getId: ZIO[Any, AwsError, ServiceNetworkVpcAssociationId] =
      AwsError.unwrapOptionField("id", id)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationResponse
  ) extends zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.ReadOnly {
    override val arn: Optional[ServiceNetworkVpcAssociationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkVpcAssociationArn(value)
        )
    override val createdBy: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.vpclattice.model.primitives.AccountId(value))
    override val id: Optional[ServiceNetworkVpcAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkVpcAssociationId(value)
        )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.vpclattice.model.ServiceNetworkVpcAssociationStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationResponse
  ): zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
