package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  VpcId,
  SecurityGroupId,
  TagValue,
  ServiceNetworkIdentifier,
  ClientToken,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceNetworkVpcAssociationRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    serviceNetworkIdentifier: ServiceNetworkIdentifier,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    vpcIdentifier: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest = {
    import CreateServiceNetworkVpcAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .serviceNetworkIdentifier(
        ServiceNetworkIdentifier.unwrap(
          serviceNetworkIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .vpcIdentifier(VpcId.unwrap(vpcIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationRequest.ReadOnly =
    zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationRequest
      .wrap(buildAwsValue())
}
object CreateServiceNetworkVpcAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationRequest =
      zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationRequest(
        clientToken.map(value => value),
        securityGroupIds.map(value => value),
        serviceNetworkIdentifier,
        tags.map(value => value),
        vpcIdentifier
      )
    def clientToken: Optional[ClientToken]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def serviceNetworkIdentifier: ServiceNetworkIdentifier
    def tags: Optional[Map[TagKey, TagValue]]
    def vpcIdentifier: VpcId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getServiceNetworkIdentifier
        : ZIO[Any, Nothing, ServiceNetworkIdentifier] =
      ZIO.succeed(serviceNetworkIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcIdentifier: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest
  ) extends zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.vpclattice.model.primitives.ClientToken(value))
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val serviceNetworkIdentifier: ServiceNetworkIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceNetworkIdentifier(impl.serviceNetworkIdentifier())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.vpclattice.model.primitives.TagKey(
              key
            ) -> zio.aws.vpclattice.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vpcIdentifier: VpcId =
      zio.aws.vpclattice.model.primitives.VpcId(impl.vpcIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest
  ): zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
