package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceNetworkServiceAssociationIdentifier,
  ServiceCustomDomainName,
  AccountId,
  ServiceNetworkServiceAssociationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceNetworkServiceAssociationResponse(
    arn: Optional[ServiceNetworkServiceAssociationArn] = Optional.Absent,
    createdBy: Optional[AccountId] = Optional.Absent,
    customDomainName: Optional[ServiceCustomDomainName] = Optional.Absent,
    dnsEntry: Optional[zio.aws.vpclattice.model.DnsEntry] = Optional.Absent,
    id: Optional[ServiceNetworkServiceAssociationIdentifier] = Optional.Absent,
    status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationResponse = {
    import CreateServiceNetworkServiceAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationResponse
      .builder()
      .optionallyWith(
        arn.map(value =>
          ServiceNetworkServiceAssociationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        createdBy.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        customDomainName.map(value =>
          ServiceCustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(dnsEntry.map(value => value.buildAwsValue()))(_.dnsEntry)
      .optionallyWith(
        id.map(value =>
          ServiceNetworkServiceAssociationIdentifier.unwrap(
            value
          ): java.lang.String
        )
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.ReadOnly =
    zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse
      .wrap(buildAwsValue())
}
object CreateServiceNetworkServiceAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse =
      zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse(
        arn.map(value => value),
        createdBy.map(value => value),
        customDomainName.map(value => value),
        dnsEntry.map(value => value.asEditable),
        id.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[ServiceNetworkServiceAssociationArn]
    def createdBy: Optional[AccountId]
    def customDomainName: Optional[ServiceCustomDomainName]
    def dnsEntry: Optional[zio.aws.vpclattice.model.DnsEntry.ReadOnly]
    def id: Optional[ServiceNetworkServiceAssociationIdentifier]
    def status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ]
    def getArn: ZIO[Any, AwsError, ServiceNetworkServiceAssociationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedBy: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCustomDomainName: ZIO[Any, AwsError, ServiceCustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getDnsEntry
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.DnsEntry.ReadOnly] =
      AwsError.unwrapOptionField("dnsEntry", dnsEntry)
    def getId: ZIO[Any, AwsError, ServiceNetworkServiceAssociationIdentifier] =
      AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationResponse
  ) extends zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.ReadOnly {
    override val arn: Optional[ServiceNetworkServiceAssociationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkServiceAssociationArn(value)
        )
    override val createdBy: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.vpclattice.model.primitives.AccountId(value))
    override val customDomainName: Optional[ServiceCustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.vpclattice.model.primitives.ServiceCustomDomainName(value)
        )
    override val dnsEntry
        : Optional[zio.aws.vpclattice.model.DnsEntry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsEntry())
        .map(value => zio.aws.vpclattice.model.DnsEntry.wrap(value))
    override val id: Optional[ServiceNetworkServiceAssociationIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.vpclattice.model.primitives
            .ServiceNetworkServiceAssociationIdentifier(value)
        )
    override val status: Optional[
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.vpclattice.model.ServiceNetworkServiceAssociationStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationResponse
  ): zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
