package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  TagValue,
  ServiceIdentifier,
  ServiceNetworkIdentifier,
  ClientToken,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceNetworkServiceAssociationRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    serviceIdentifier: ServiceIdentifier,
    serviceNetworkIdentifier: ServiceNetworkIdentifier,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest = {
    import CreateServiceNetworkServiceAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .serviceNetworkIdentifier(
        ServiceNetworkIdentifier.unwrap(
          serviceNetworkIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationRequest.ReadOnly =
    zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationRequest
      .wrap(buildAwsValue())
}
object CreateServiceNetworkServiceAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationRequest =
      zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationRequest(
        clientToken.map(value => value),
        serviceIdentifier,
        serviceNetworkIdentifier,
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def serviceIdentifier: ServiceIdentifier
    def serviceNetworkIdentifier: ServiceNetworkIdentifier
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
    def getServiceNetworkIdentifier
        : ZIO[Any, Nothing, ServiceNetworkIdentifier] =
      ZIO.succeed(serviceNetworkIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest
  ) extends zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.vpclattice.model.primitives.ClientToken(value))
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
    override val serviceNetworkIdentifier: ServiceNetworkIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceNetworkIdentifier(impl.serviceNetworkIdentifier())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.vpclattice.model.primitives.TagKey(
              key
            ) -> zio.aws.vpclattice.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest
  ): zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
