package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  TagValue,
  TagKey,
  ServiceNetworkName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceNetworkRequest(
    authType: Optional[zio.aws.vpclattice.model.AuthType] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    name: ServiceNetworkName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest = {
    import CreateServiceNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest
      .builder()
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .name(ServiceNetworkName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.CreateServiceNetworkRequest.ReadOnly =
    zio.aws.vpclattice.model.CreateServiceNetworkRequest.wrap(buildAwsValue())
}
object CreateServiceNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.CreateServiceNetworkRequest =
      zio.aws.vpclattice.model.CreateServiceNetworkRequest(
        authType.map(value => value),
        clientToken.map(value => value),
        name,
        tags.map(value => value)
      )
    def authType: Optional[zio.aws.vpclattice.model.AuthType]
    def clientToken: Optional[ClientToken]
    def name: ServiceNetworkName
    def tags: Optional[Map[TagKey, TagValue]]
    def getAuthType: ZIO[Any, AwsError, zio.aws.vpclattice.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, ServiceNetworkName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest
  ) extends zio.aws.vpclattice.model.CreateServiceNetworkRequest.ReadOnly {
    override val authType: Optional[zio.aws.vpclattice.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.vpclattice.model.AuthType.wrap(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.vpclattice.model.primitives.ClientToken(value))
    override val name: ServiceNetworkName =
      zio.aws.vpclattice.model.primitives.ServiceNetworkName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.vpclattice.model.primitives.TagKey(
              key
            ) -> zio.aws.vpclattice.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest
  ): zio.aws.vpclattice.model.CreateServiceNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
