package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  RulePriority,
  RuleName,
  RuleId,
  RuleArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateRuleResponse(
    action: Optional[zio.aws.vpclattice.model.RuleAction] = Optional.Absent,
    arn: Optional[RuleArn] = Optional.Absent,
    id: Optional[RuleId] = Optional.Absent,
    `match`: Optional[zio.aws.vpclattice.model.RuleMatch] = Optional.Absent,
    name: Optional[RuleName] = Optional.Absent,
    priority: Optional[RulePriority] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateRuleResponse = {
    import CreateRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateRuleResponse
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(
        arn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(id.map(value => RuleId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(`match`.map(value => value.buildAwsValue()))(_.`match`)
      .optionallyWith(
        name.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        priority.map(value => RulePriority.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.CreateRuleResponse.ReadOnly =
    zio.aws.vpclattice.model.CreateRuleResponse.wrap(buildAwsValue())
}
object CreateRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.CreateRuleResponse =
      zio.aws.vpclattice.model.CreateRuleResponse(
        action.map(value => value.asEditable),
        arn.map(value => value),
        id.map(value => value),
        `match`.map(value => value.asEditable),
        name.map(value => value),
        priority.map(value => value)
      )
    def action: Optional[zio.aws.vpclattice.model.RuleAction.ReadOnly]
    def arn: Optional[RuleArn]
    def id: Optional[RuleId]
    def `match`: Optional[zio.aws.vpclattice.model.RuleMatch.ReadOnly]
    def name: Optional[RuleName]
    def priority: Optional[RulePriority]
    def getAction
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, RuleId] = AwsError.unwrapOptionField("id", id)
    def getMatch
        : ZIO[Any, AwsError, zio.aws.vpclattice.model.RuleMatch.ReadOnly] =
      AwsError.unwrapOptionField("match", `match`)
    def getName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, RulePriority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateRuleResponse
  ) extends zio.aws.vpclattice.model.CreateRuleResponse.ReadOnly {
    override val action
        : Optional[zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.vpclattice.model.RuleAction.wrap(value))
    override val arn: Optional[RuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.vpclattice.model.primitives.RuleArn(value))
    override val id: Optional[RuleId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.vpclattice.model.primitives.RuleId(value))
    override val `match`
        : Optional[zio.aws.vpclattice.model.RuleMatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`match`())
        .map(value => zio.aws.vpclattice.model.RuleMatch.wrap(value))
    override val name: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.vpclattice.model.primitives.RuleName(value))
    override val priority: Optional[RulePriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.vpclattice.model.primitives.RulePriority(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateRuleResponse
  ): zio.aws.vpclattice.model.CreateRuleResponse.ReadOnly = new Wrapper(impl)
}
