package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  TagValue,
  ServiceIdentifier,
  RuleName,
  ClientToken,
  RulePriority,
  ListenerIdentifier,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateRuleRequest(
    action: zio.aws.vpclattice.model.RuleAction,
    clientToken: Optional[ClientToken] = Optional.Absent,
    listenerIdentifier: ListenerIdentifier,
    `match`: zio.aws.vpclattice.model.RuleMatch,
    name: RuleName,
    priority: RulePriority,
    serviceIdentifier: ServiceIdentifier,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest = {
    import CreateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest
      .builder()
      .action(action.buildAwsValue())
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .listenerIdentifier(
        ListenerIdentifier.unwrap(listenerIdentifier): java.lang.String
      )
      .`match`(`match`.buildAwsValue())
      .name(RuleName.unwrap(name): java.lang.String)
      .priority(RulePriority.unwrap(priority): Integer)
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.CreateRuleRequest.ReadOnly =
    zio.aws.vpclattice.model.CreateRuleRequest.wrap(buildAwsValue())
}
object CreateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.CreateRuleRequest =
      zio.aws.vpclattice.model.CreateRuleRequest(
        action.asEditable,
        clientToken.map(value => value),
        listenerIdentifier,
        `match`.asEditable,
        name,
        priority,
        serviceIdentifier,
        tags.map(value => value)
      )
    def action: zio.aws.vpclattice.model.RuleAction.ReadOnly
    def clientToken: Optional[ClientToken]
    def listenerIdentifier: ListenerIdentifier
    def `match`: zio.aws.vpclattice.model.RuleMatch.ReadOnly
    def name: RuleName
    def priority: RulePriority
    def serviceIdentifier: ServiceIdentifier
    def tags: Optional[Map[TagKey, TagValue]]
    def getAction
        : ZIO[Any, Nothing, zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      ZIO.succeed(action)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getListenerIdentifier: ZIO[Any, Nothing, ListenerIdentifier] =
      ZIO.succeed(listenerIdentifier)
    def getMatch
        : ZIO[Any, Nothing, zio.aws.vpclattice.model.RuleMatch.ReadOnly] =
      ZIO.succeed(`match`)
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getPriority: ZIO[Any, Nothing, RulePriority] = ZIO.succeed(priority)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest
  ) extends zio.aws.vpclattice.model.CreateRuleRequest.ReadOnly {
    override val action: zio.aws.vpclattice.model.RuleAction.ReadOnly =
      zio.aws.vpclattice.model.RuleAction.wrap(impl.action())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.vpclattice.model.primitives.ClientToken(value))
    override val listenerIdentifier: ListenerIdentifier =
      zio.aws.vpclattice.model.primitives
        .ListenerIdentifier(impl.listenerIdentifier())
    override val `match`: zio.aws.vpclattice.model.RuleMatch.ReadOnly =
      zio.aws.vpclattice.model.RuleMatch.wrap(impl.`match`())
    override val name: RuleName =
      zio.aws.vpclattice.model.primitives.RuleName(impl.name())
    override val priority: RulePriority =
      zio.aws.vpclattice.model.primitives.RulePriority(impl.priority())
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.vpclattice.model.primitives.TagKey(
              key
            ) -> zio.aws.vpclattice.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest
  ): zio.aws.vpclattice.model.CreateRuleRequest.ReadOnly = new Wrapper(impl)
}
