package zio.aws.vpclattice.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.vpclattice.model.primitives.{
  TagValue,
  Port,
  ServiceIdentifier,
  ClientToken,
  ListenerName,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateListenerRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    defaultAction: zio.aws.vpclattice.model.RuleAction,
    name: ListenerName,
    port: Optional[Port] = Optional.Absent,
    protocol: zio.aws.vpclattice.model.ListenerProtocol,
    serviceIdentifier: ServiceIdentifier,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest = {
    import CreateListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .defaultAction(defaultAction.buildAwsValue())
      .name(ListenerName.unwrap(name): java.lang.String)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .protocol(protocol.unwrap)
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.CreateListenerRequest.ReadOnly =
    zio.aws.vpclattice.model.CreateListenerRequest.wrap(buildAwsValue())
}
object CreateListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.CreateListenerRequest =
      zio.aws.vpclattice.model.CreateListenerRequest(
        clientToken.map(value => value),
        defaultAction.asEditable,
        name,
        port.map(value => value),
        protocol,
        serviceIdentifier,
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def defaultAction: zio.aws.vpclattice.model.RuleAction.ReadOnly
    def name: ListenerName
    def port: Optional[Port]
    def protocol: zio.aws.vpclattice.model.ListenerProtocol
    def serviceIdentifier: ServiceIdentifier
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.vpclattice.model.RuleAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getName: ZIO[Any, Nothing, ListenerName] = ZIO.succeed(name)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.vpclattice.model.ListenerProtocol] =
      ZIO.succeed(protocol)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest
  ) extends zio.aws.vpclattice.model.CreateListenerRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.vpclattice.model.primitives.ClientToken(value))
    override val defaultAction: zio.aws.vpclattice.model.RuleAction.ReadOnly =
      zio.aws.vpclattice.model.RuleAction.wrap(impl.defaultAction())
    override val name: ListenerName =
      zio.aws.vpclattice.model.primitives.ListenerName(impl.name())
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.vpclattice.model.primitives.Port(value))
    override val protocol: zio.aws.vpclattice.model.ListenerProtocol =
      zio.aws.vpclattice.model.ListenerProtocol.wrap(impl.protocol())
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.vpclattice.model.primitives.TagKey(
              key
            ) -> zio.aws.vpclattice.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest
  ): zio.aws.vpclattice.model.CreateListenerRequest.ReadOnly = new Wrapper(impl)
}
